/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.services.AttachmentService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.IOException;

public class AttachmentDelete
implements Action {
    private I18N i18n = Application.getI18n();
    private AttachmentService service = (AttachmentService)Application.getBootLoader().getBootable(AttachmentService.class);

    @Override
    public void handleAction(Object context) throws ApplicationException {
        Attachment[] list = null;
        if (context instanceof Attachment) {
            list = new Attachment[]{(Attachment)context};
        } else if (context instanceof Attachment[]) {
            list = (Attachment[])context;
        }
        if (list == null || list.length == 0) {
            throw new ApplicationException(this.i18n.tr("Bitte w\u00e4hlen Sie die zu l\u00f6schenden Dateien."));
        }
        String text = list.length == 1 ? "Sind Sie sicher, dass Sie den Dateianhang l\u00f6schen wollen?" : "Sind Sie sicher, dass Sie die Dateianh\u00e4nge l\u00f6schen wollen?";
        try {
            boolean ok = Application.getCallback().askUser(this.i18n.tr(text), true);
            if (!ok) {
                throw new OperationCanceledException();
            }
            int count = 0;
            for (Attachment a : list) {
                try {
                    this.service.delete(a);
                    ++count;
                }
                catch (IOException e) {
                    Logger.error((String)("error while deleting " + a.getFilename()), (Throwable)e);
                }
            }
            Logger.info((String)("deleted " + count + " attachments"));
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException ae) {
        }
        catch (Exception e) {
            Logger.error((String)"unable to delete attachments", (Throwable)e);
            throw new ApplicationException(this.i18n.tr("L\u00f6schen der Dateianh\u00e4nge fehlgeschlagen"));
        }
    }
}

